#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<pthread.h>

#define BrojVozila 30

//Vozila mogu da budu neograniceno; Autobus samo jedan ali mogu i autmobili; Kamion samo on na celom nadvoznjaku

pthread_mutex_t mutex;
pthread_cond_t cond;

int smerA=0,smerB=0;

int brAutomobila=0,brAutobusa=0,brKamiona=0;

void* workAutomobil(void *arg){
	long id = (long)arg;
	int smer = rand()%2; //0 - smer A; 1 - smer B
	sleep(rand()%5);
	if(!smer){
		pthread_mutex_lock(&mutex);
		while(smerB>0 || brKamiona>0) pthread_cond_wait(&cond,&mutex);
		smerA++;
		brAutomobila++;
		pthread_mutex_unlock(&mutex);
		
		printf("AUTOMOBIL %ld iz smera A prelazi most\n",id);
		sleep(3);
		
		pthread_mutex_lock(&mutex);
		smerA--;
		brAutomobila--;
		printf("AUTOMOBIL %ld je presao\n",id); //postavljeno unutar mutex-a jer se desava gresku u ispisu, npr da ispise da je kamion usao u traku a da je tek posle izasao autobus
		if(smerA==0) pthread_cond_broadcast(&cond);
		pthread_mutex_unlock(&mutex);
	}
	else{
		pthread_mutex_lock(&mutex);
		while(smerA>0 || brKamiona>0) pthread_cond_wait(&cond,&mutex);
		smerB++;
		brAutomobila++;
		pthread_mutex_unlock(&mutex);
		
		printf("AUTOMOBIL %ld iz smera B prelazi most\n",id);
		sleep(3);
		
		pthread_mutex_lock(&mutex);
		smerB--;
		brAutomobila--;
		printf("AUTOMOBIL %ld je presao\n",id);
		if(smerB==0) pthread_cond_broadcast(&cond);
		pthread_mutex_unlock(&mutex);
		
	}
	pthread_exit(NULL);
}

void* workAutobus(void *arg){
	long id = (long)arg;
	int smer = rand()%2; //0 - smer A; 1 - smer B
	sleep(rand()%5);
	if(!smer){
		pthread_mutex_lock(&mutex);
		while(smerB>0 || brAutobusa>0 || brKamiona>0) pthread_cond_wait(&cond,&mutex);
		smerA++;
		brAutobusa++;
		pthread_mutex_unlock(&mutex);
		
		printf("AUTOBUS %ld iz smera A prelazi most\n",id);
		sleep(3);
		
		pthread_mutex_lock(&mutex);
		smerA--;
		brAutobusa--;
		printf("AUTOBUS %ld je presao\n",id);
		if(smerA==0 || brAutobusa==0) pthread_cond_broadcast(&cond);
		pthread_mutex_unlock(&mutex);
	}
	else{
		pthread_mutex_lock(&mutex);
		while(smerA>0 || brAutobusa>0 || brKamiona>0) pthread_cond_wait(&cond,&mutex);
		smerB++;
		brAutobusa++;
		pthread_mutex_unlock(&mutex);
		
		printf("AUTOBUS %ld iz smera B prelazi most\n",id);
		sleep(3);
		
		pthread_mutex_lock(&mutex);
		smerB--;
		brAutobusa--;
		printf("AUTOBUS %ld je presao\n",id);
		if(smerB==0 || brAutobusa==0) pthread_cond_broadcast(&cond);
		pthread_mutex_unlock(&mutex);
	}
	pthread_exit(NULL);
}

void* workKamion(void *arg){
	long id = (long)arg;
	int smer = rand()%2; //0 - smer A; 1 - smer B
	sleep(rand()%5);
	if(!smer){
		pthread_mutex_lock(&mutex);
		while(smerB>0 || smerA>0) pthread_cond_wait(&cond,&mutex);
		smerA++;
		brKamiona++;
		pthread_mutex_unlock(&mutex);
		
		printf("KAMION %ld iz smera A prelazi most\n",id);
		sleep(5);
		
		pthread_mutex_lock(&mutex);
		smerA--;
		brKamiona--;
		printf("KAMION %ld je presao\n",id);
		pthread_cond_broadcast(&cond);
		pthread_mutex_unlock(&mutex);
	}
	else{
		pthread_mutex_lock(&mutex);
		while(smerA>0 || smerB>0) pthread_cond_wait(&cond,&mutex);
		smerB++;
		brKamiona++;
		pthread_mutex_unlock(&mutex);
		
		printf("KAMION %ld iz smera B prelazi most\n",id);
		sleep(5);
		
		pthread_mutex_lock(&mutex);
		smerB--;
		brKamiona--;
		printf("KAMION %ld je presao\n",id);
		pthread_cond_broadcast(&cond);
		pthread_mutex_unlock(&mutex);
	}

	pthread_exit(NULL);
}

int main(){
	pthread_t t[BrojVozila];
	pthread_mutex_init(&mutex,NULL);
	pthread_cond_init(&cond,NULL);
	srand(time(NULL));
	
	for(long i=0;i<BrojVozila;i++){
		int vozilo = rand()%3;
		if(vozilo==0){
			pthread_create(t+i,NULL,workAutomobil,(void*)i);
		}
		else if(vozilo==1){
			pthread_create(t+i,NULL,workAutobus,(void*)i);
		}
		else{
			pthread_create(t+i,NULL,workKamion,(void*)i);		
		}	
	
	}
	for(long i=0;i<BrojVozila;i++)
		pthread_join(t[i],NULL);
	
	return 0;
}
